<?php
// update_vouchers_table.php - Add username and password columns to vouchers table
echo "<h2>Updating Vouchers Table Structure</h2>";

$db = new mysqli('localhost', 'root', '', 'hotspot_vouchers');

if ($db->connect_error) {
    die("Connection failed: " . $db->connect_error);
}

// Add username column if it doesn't exist
echo "<h3>1. Checking for username column...</h3>";
$result = $db->query("SHOW COLUMNS FROM vouchers LIKE 'username'");
if ($result->num_rows == 0) {
    $sql = "ALTER TABLE vouchers ADD COLUMN username VARCHAR(255) AFTER voucher_code";
    if ($db->query($sql)) {
        echo "<p style='color: green;'>✅ Added 'username' column to vouchers table</p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to add username column: " . $db->error . "</p>";
    }
} else {
    echo "<p style='color: green;'>✅ 'username' column already exists</p>";
}

// Add password column if it doesn't exist
echo "<h3>2. Checking for password column...</h3>";
$result = $db->query("SHOW COLUMNS FROM vouchers LIKE 'password'");
if ($result->num_rows == 0) {
    $sql = "ALTER TABLE vouchers ADD COLUMN password VARCHAR(255) AFTER username";
    if ($db->query($sql)) {
        echo "<p style='color: green;'>✅ Added 'password' column to vouchers table</p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to add password column: " . $db->error . "</p>";
    }
} else {
    echo "<p style='color: green;'>✅ 'password' column already exists</p>";
}

// Show current table structure
echo "<h3>3. Current vouchers table structure:</h3>";
$result = $db->query("DESCRIBE vouchers");
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
while ($row = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . $row['Field'] . "</td>";
    echo "<td>" . $row['Type'] . "</td>";
    echo "<td>" . $row['Null'] . "</td>";
    echo "<td>" . $row['Key'] . "</td>";
    echo "<td>" . $row['Default'] . "</td>";
    echo "<td>" . $row['Extra'] . "</td>";
    echo "</tr>";
}
echo "</table>";

$db->close();

echo "<hr><p><a href='load_preloaded_accounts.php'>← Load Preloaded Accounts</a></p>";
?>