<?php
// redirect.php - Handle MikroTik redirects
$request_uri = $_SERVER['REQUEST_URI'];

// Extract the problematic URL
if (preg_match('/\\$\\(link-login-only\\)/', $request_uri)) {
    // Redirect to the main login page
    header('Location: /hotspot_voucher/login.php');
    exit;
}

// If it's a normal login request, process it
if (isset($_POST['username']) && isset($_POST['password'])) {
    // Handle the actual login authentication here
    $username = $_POST['username'];
    $password = $_POST['password'];
    
    // Your login logic here
    // If login successful, redirect to status page
    header('Location: http://' . $_SERVER['HTTP_HOST'] . '/status');
    exit;
}

// Default redirect
header('Location: /hotspot_voucher/login.php');
exit;
?>