<?php
require_once 'config.php';

// This script is for loading vouchers into the database
if ($_POST['action'] ?? '' === 'load_vouchers') {
    $csv_data = $_POST['csv_data'] ?? '';
    
    if (empty($csv_data)) {
        die('No CSV data provided');
    }
    
    $lines = explode("\n", trim($csv_data));
    $db = getDB();
    $loaded = 0;
    $errors = 0;
    
    foreach ($lines as $line) {
        $data = str_getcsv(trim($line));
        if (count($data) >= 3) {
            $voucher_code = trim($data[0]);
            $amount = floatval(trim($data[1]));
            $profile_name = trim($data[2]);
            
            try {
                $stmt = $db->prepare("INSERT INTO vouchers (voucher_code, amount, profile_name) VALUES (?, ?, ?)");
                $stmt->bind_param('sds', $voucher_code, $amount, $profile_name);
                if ($stmt->execute()) {
                    $loaded++;
                }
                $stmt->close();
            } catch (Exception $e) {
                $errors++;
            }
        }
    }
    
    echo "Loaded: $loaded vouchers, Errors: $errors";
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Load Vouchers</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 20px; }
        textarea { width: 100%; height: 300px; margin: 10px 0; }
        button { padding: 10px 20px; background: #007bff; color: white; border: none; cursor: pointer; }
    </style>
</head>
<body>
    <h1>Load Vouchers into Database</h1>
    <p>Format: voucher_code,amount,profile_name (one per line)</p>
    <form method="POST">
        <textarea name="csv_data" placeholder="VOUCHER001,11,profile name-11GH
VOUCHER002,15,profile name-15GH
VOUCHER003,22,profile name-22GH"></textarea>
        <br>
        <button type="submit" name="action" value="load_vouchers">Load Vouchers</button>
    </form>
</body>
</html>