<?php
// This file is no longer needed since we're doing direct Paystack integration
// Keeping it for backward compatibility

require_once 'config.php';

header('Content-Type: application/json');

// Generate credentials
$credentials = generateCredentials();
$username = $credentials['username'];
$password = $credentials['password'];

$reference = 'KRV' . time() . mt_rand(1000, 9999);

// Save to database for later retrieval
$db = getDB();
$stmt = $db->prepare("INSERT INTO transactions (paystack_reference, username, password, amount, status) VALUES (?, ?, ?, ?, 'pending')");
$stmt->bind_param('sssi', $reference, $username, $password, $_POST['amount']);
$stmt->execute();
$stmt->close();

echo json_encode([
    'status' => true,
    'message' => 'Ready for payment',
    'data' => [
        'reference' => $reference,
        'username' => $username,
        'password' => $password
    ]
]);
?>